% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beakr.R
\docType{class}
\name{Beakr}
\alias{Beakr}
\title{Beakr Application Class}
\format{
An [`R6::R6Class`] generator for `Beakr` objects.
}
\description{
A `Beakr` object defines a web server instance using the [`httpuv`] package.
It provides the main entry point for creating and starting a Beakr
application, wrapping a [`Router`] and exposing lifecycle methods.
}
\seealso{
[Router], [Middleware], [httpuv::startServer], [httpuv::runServer]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Application name. If `NULL`, a random name is set in `$initialize()`.}

\item{\code{router}}{The `Router` instance used to handle requests.}

\item{\code{server}}{The underlying `httpuv` server object (once started).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Beakr-appDefinition}{\code{Beakr$appDefinition()}}
\item \href{#method-Beakr-new}{\code{Beakr$new()}}
\item \href{#method-Beakr-start}{\code{Beakr$start()}}
\item \href{#method-Beakr-print}{\code{Beakr$print()}}
\item \href{#method-Beakr-clone}{\code{Beakr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Beakr-appDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-Beakr-appDefinition}{}}}
\subsection{Method \code{appDefinition()}}{
Build the application definition passed to **httpuv** (request & WS handlers).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$appDefinition()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Beakr-new"></a>}}
\if{latex}{\out{\hypertarget{method-Beakr-new}{}}}
\subsection{Method \code{new()}}{
Initialize the app: create a `Router` and assign a random `name` if missing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Beakr-start"></a>}}
\if{latex}{\out{\hypertarget{method-Beakr-start}{}}}
\subsection{Method \code{start()}}{
Start the HTTP server via **httpuv**.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$start(host, port, daemon)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Hostname or IP to bind.}

\item{\code{port}}{Integer port to listen on.}

\item{\code{daemon}}{If `TRUE`, run in background with `httpuv::startServer()`;
otherwise run foreground with `httpuv::runServer()`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Beakr-print"></a>}}
\if{latex}{\out{\hypertarget{method-Beakr-print}{}}}
\subsection{Method \code{print()}}{
Print a one-line summary (name, state, host, port, #middlewares).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Beakr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Beakr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
