% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_distrib.R
\name{sample_nb}
\alias{sample_nb}
\title{Sample from negative binomial model given a set of predictions}
\usage{
sample_nb(pred, uncertainty_params)
}
\arguments{
\item{pred}{Vector of predictions.}

\item{uncertainty_params}{Vector of uncertainty parameters.}
}
\value{
\code{sampled_pred} Object of the same dimensions as \code{pred} representing
a single draw from the negative binomial distribution
with the specified \verb{uncertainty params}.
}
\description{
Sample from negative binomial model given a set of predictions
}
\examples{
pred <- c(3.2, 4.6)
sampled_preds <- sample_nb(pred,
  uncertainty_params = c(50, 100)
)
sampled_preds
}
\seealso{
Probabilistic nowcast generation functions
\code{\link{combine_obs_with_pred}()},
\code{\link{sample_nowcast}()},
\code{\link{sample_nowcasts}()},
\code{\link{sample_prediction}()},
\code{\link{sample_predictions}()}
}
\concept{generate_probabilistic_nowcasts}
