% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_acls}
\alias{ec2_describe_network_acls}
\title{Describe Network Acls}
\usage{
ec2_describe_network_acls(
  Filter = NULL,
  DryRun = NULL,
  NetworkAclId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NetworkAclId}{List.   One or more network ACL IDs.  Default: Describes all your network ACLs.  [optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Network Acls
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{association.association-id} - The ID of an association ID for the
ACL.
\item \code{association.network-acl-id} - The ID of the network ACL involved in
the association.
\item \code{association.subnet-id} - The ID of the subnet involved in the
association.
\item \code{default} - Indicates whether the ACL is the default network ACL for
the VPC.
\item \code{entry.cidr} - The IPv4 CIDR range specified in the entry.
\item \code{entry.icmp.code} - The ICMP code specified in the entry, if any.
\item \code{entry.icmp.type} - The ICMP type specified in the entry, if any.
\item \code{entry.ipv6-cidr} - The IPv6 CIDR range specified in the entry.
\item \code{entry.port-range.from} - The start of the port range specified in
the entry.
\item \code{entry.port-range.to} - The end of the port range specified in the
entry.
\item \code{entry.protocol} - The protocol specified in the entry (\code{tcp} \|
\code{udp} \| \code{icmp} or a protocol number).
\item \code{entry.rule-action} - Allows or denies the matching traffic (\code{allow}
\| \code{deny}).
\item \code{entry.rule-number} - The number of an entry (in other words, rule)
in the set of ACL entries.
\item \code{network-acl-id} - The ID of the network ACL.
\item \code{owner-id} - The ID of the AWS account that owns the network ACL.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC for the network ACL.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{NetworkAclId}{


One or more network ACL IDs.

Default: Describes all your network ACLs.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

