% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_snapshots}
\alias{ec2_create_snapshots}
\title{Create Snapshots}
\usage{
ec2_create_snapshots(
  InstanceSpecification,
  Description = NULL,
  OutpostArn = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  CopyTagsFromSource = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{InstanceSpecification}{Object. The instance to specify which volumes should be included in the snapshots.}

\item{Description}{Character.  A description propagated to every snapshot specified by the instance.[optional]}

\item{OutpostArn}{Character.   The Amazon Resource Name (ARN) of the AWS Outpost on which to create the local snapshots.[optional]}

\item{TagSpecification}{List. Tags to apply to every snapshot specified by the instance.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{CopyTagsFromSource}{Character. Copies the tags from the specified volume to corresponding snapshot.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Snapshots
}
\section{InstanceSpecification}{

The instance to specify
which volumes should be included in the snapshots.
}

\section{Description}{


A description propagated to every snapshot specified by the
instance.
}

\section{OutpostArn}{


The Amazon Resource Name (ARN) of the AWS Outpost on which to create the
local snapshots.
\itemize{
\item To create snapshots from an instance in a Region, omit this
parameter. The snapshots are created in the same Region as the
instance.
\item To create snapshots from an instance on an Outpost and store the
snapshots in the Region, omit this parameter. The snapshots are
created in the Region for the Outpost.
\item To create snapshots from an instance on an Outpost and store the
snapshots on an Outpost, specify the ARN of the destination Outpost.
The snapshots must be created on the same Outpost as the instance.
}

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-multivol-snapshot}{Creating multi-volume local snapshots from instances on an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{TagSpecification}{

Tags to apply to every snapshot specified by the
instance.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{CopyTagsFromSource}{

Copies the tags from the
specified volume to corresponding snapshot.
}

