% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_palettes.R
\name{validate_stratpal}
\alias{validate_stratpal}
\title{Validate a stratigraphic palette}
\usage{
validate_stratpal(pal, allow_na = FALSE, na_color = "gray90")
}
\arguments{
\item{pal}{Named character vector of colors.}

\item{allow_na}{Logical. If TRUE, missing categories are filled with
\code{na_color} instead of erroring.}

\item{na_color}{Color to use for missing categories when
\code{allow_na = TRUE}.}
}
\value{
A complete palette (named character vector) ordered to match
the required categories.
}
\description{
Ensures that a palette covers all required categories. By default,
missing categories trigger an error. If \code{allow_na = TRUE}, missing
categories are filled with a default color instead.
}
\examples{
# A complete palette passes validation
validate_stratpal(stratpal_rpg)

# Allow missing categories to be filled with gray
validate_stratpal(stratpal_grays, allow_na = TRUE)
}
