% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kruskal_Wallis.R
\name{teste.kruskal}
\alias{teste.kruskal}
\title{Teste de Kruskal-Wallis com pos-teste de Dunn}
\usage{
teste.kruskal(
  ...,
  titulo = "Kruskal-Wallis + Dunn",
  x = "Grupo",
  y = "Valor",
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{...}{Vetores numericos representando os grupos a serem comparados.}

\item{titulo}{Titulo do grafico (padrao = "Kruskal-Wallis + Dunn").}

\item{x}{Nome do eixo x (padrao = "Grupo").}

\item{y}{Nome do eixo y (padrao = "Valor").}

\item{ajuda}{Se TRUE, exibe esta mensagem de ajuda.}

\item{verbose}{Se TRUE, imprime mensagens detalhadas (default = TRUE)}
}
\value{
Objeto da classe \code{htest} resultante do teste de Kruskal-Wallis.
}
\description{
Realiza o teste de Kruskal-Wallis para comparacao de multiplos grupos independentes
quando a suposicao de normalidade nao e atendida, seguido do pos-teste de Dunn com ajuste de Bonferroni.
Exibe resultado numerico e grafico com letras de significancia.
}
\details{
O teste de Kruskal-Wallis e uma alternativa nao parametrica a ANOVA para comparar a mediana de tres ou mais grupos independentes.
Quando o resultado e significativo, aplica-se o teste pos-hoc de Dunn com correcao de Bonferroni para identificar pares de grupos diferentes.
}
\section{Quando usar}{

\itemize{
\item Para dados que nao seguem distribuicao normal;
\item Para variaveis ordinais ou continuas;
\item Para comparar 3 ou mais grupos independentes.
}
}

\examples{
g1 <- c(5, 6, 7)
g2 <- c(8, 9, 10)
g3 <- c(2, 3, 4)
teste.kruskal(g1, g2, g3)

}
