% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_barcharts.R
\name{process_barcharts}
\alias{process_barcharts}
\title{Process eBird bar chart data}
\usage{
process_barcharts(filename)
}
\arguments{
\item{filename}{character; path to the bar chart data text file downloaded
from the eBird website.}
}
\value{
This functions returns a data frame in long format where each row
provides data for one species in one week. \code{detection_frequency} gives the
proportion of checklists in the region that reported the species in the
given week and \code{n_detections} gives the number of detections. The total
number of checklists in each week used to estimate detection frequency is
provided as a data frame stored in the \code{sample_sizes} attribute. Note that
since most months have more than 28 days, the first three weeks have 7
days, but the final week has between 7-10 days.
}
\description{
eBird bar charts show the frequency of detection for each week for all
species within a region. These can be accessed by visiting any region or
hotspot page and clicking the "Bar Charts" link in the left column. As an
example, these \href{https://ebird.org/barchart?r=GT&yr=all&m=}{bar charts for Guatemala} list all the species
(as well as non-species taxa) that have been observed in eBird in Guatemala
and, for each species, the width of the green bar reflects the frequency of
detections on eBird checklists within the region (referred to as detection
frequency). Detection frequency is provide for each of 4 "weeks" of each
month (although these are not technically 7 day weeks since months have more
than 28 days). The data underlying the bar charts can be downloaded via a
link at the bottom right of the page; however, the text file that's
downloaded is in a challenging format to work with. This function is designed
to read these text files and return a nicely formatted data frame for use in
R.
}
\examples{
# example bar chart data for svalbard
f <- system.file("extdata/barchart-sample.txt", package = "auk")
# import and process barchart data
barcharts <- process_barcharts(f)
head(barcharts)

# the sample sizes for each week can be access with
attr(barcharts, "sample_sizes")

# bar charts include data for non-species taxa
# use category to filter to only species
barcharts[barcharts$category == "species", ]
}
\seealso{
Other helpers: 
\code{\link{auk_ebd_version}()},
\code{\link{auk_version}()},
\code{\link{ebird_species}()},
\code{\link{get_ebird_taxonomy}()}
}
\concept{helpers}
