% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-metadata.R
\docType{methods}
\name{GHL}
\alias{GHL}
\alias{GHL,SoilProfileCollection-method}
\alias{GHL<-}
\alias{GHL<-,SoilProfileCollection-method}
\title{Get or Set Generalized Horizon Label (GHL) Column Name}
\usage{
\S4method{GHL}{SoilProfileCollection}(object, required = FALSE)

\S4method{GHL}{SoilProfileCollection}(object, required = FALSE) <- value
}
\arguments{
\item{object}{a SoilProfileCollection}

\item{required}{logical, is this attribute required? If it is, set to \code{TRUE} to trigger error on invalid \code{value}.}

\item{value}{character, name of column containing generalized horizon labels}
}
\description{
\code{GHL()}: Get column name containing generalized horizon labels

\verb{GHL<-}: Set generalized horizon label column name
}
\details{
Store the column name containing generalized horizon labels in the metadata slot of the SoilProfileCollection.
}
\examples{

data(sp1)

# promote to SPC
depths(sp1) <- id ~ top + bottom

# set horizon designation column
GHL(sp1) <- "name"

# get horizon designation column
GHL(sp1)
}
