% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{apa_performance_comparison}
\alias{apa_performance_comparison}
\title{format model comparison metrics in APA style}
\usage{
apa_performance_comparison(
  ...,
  metrics = c("R2", "deltaR2", "F", "p"),
  starred = NA,
  column_formats = NULL
)
}
\arguments{
\item{...}{model fit objects}

\item{metrics}{performance metrics. Default is R2, deltaR2, F, and p}

\item{starred}{columns to star with significant p_values}

\item{column_formats}{column_formats object to format columns. If NULL, the default column_formats is used.}
}
\value{
tibble
}
\description{
format model comparison metrics in APA style
}
\examples{
m1 <- lm(mpg ~ cyl, data = mtcars)
m2 <- lm(mpg ~ cyl + wt, data = mtcars)
apa_performance_comparison(list(`Model 1` =m1, `Model 3` =m2)) |>
   apa_flextable()
}
