% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAntaresClusters.R
\name{readAntaresSTClusters}
\alias{readAntaresSTClusters}
\title{Read output for a list of short-term storage clusters}
\usage{
readAntaresSTClusters(
  clustersST,
  selected = c("P.injection", "levels", "P.withdrawal"),
  timeStep = c("hourly", "daily", "weekly", "monthly", "annual"),
  opts = simOptions(),
  parallel = FALSE,
  showProgress = TRUE
)
}
\arguments{
\item{clustersST}{vector of short-term storage clusters to be imported}

\item{selected}{vector of thematic trimming}

\item{timeStep}{Resolution of the data to import: hourly (default), daily,
weekly, monthly or annual.}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{parallel}{Should the importation be parallelized ? (See details)}

\item{showProgress}{If TRUE the function displays information about the progress of the
importation.}
}
\value{
data.table of results for short-term storage clusters
}
\description{
Read output for a list of short-term storage clusters
}
