% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateOutputSettings.R
\name{updateOutputSettings}
\alias{updateOutputSettings}
\title{Update output parameters of an Antares study}
\usage{
updateOutputSettings(
  synthesis = NULL,
  storenewset = NULL,
  archives = NULL,
  result.format = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{synthesis}{Logical. If TRUE, synthetic results will be stored in a
directory Study_name/OUTPUT/simu_tag/Economy/mc-all. If FALSE, No general
synthesis will be printed out. See Antares General Reference Guide (see link below).}

\item{storenewset}{Logical. See Antares General Reference Guide (see link below).}

\item{archives}{Character vector. Series to archive. See Antares General Reference Guide (see link below).}

\item{result.format}{Character. Output format (txt-files or zip). See Antares General Reference Guide (see link below).}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Update output parameters of an Antares study
}
\examples{
\dontrun{

updateOutputSettings(
  synthesis = TRUE,
  storenewset = FALSE,
  archives = c("load", "wind"),
  result.format = "zip"
)

}

}
\seealso{
{Antares General Reference Guide}
}
