% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_go_terms.R
\name{add_go_terms}
\alias{add_go_terms}
\title{Add GO functional enrichment data}
\usage{
add_go_terms(annotaR_object, organism = "hsapiens", sources = c("GO:BP"), ...)
}
\arguments{
\item{annotaR_object}{A tibble, typically the output of \code{annotaR()}. Must
contain a 'gene' column.}

\item{organism}{The organism name to use for the query (e.g., "hsapiens").
Passed to \code{gprofiler2::gost}.}

\item{sources}{A vector of data sources to query. Defaults to GO Biological
Process. See \code{gprofiler2::gost} for options.}

\item{...}{Additional parameters passed on to \code{gprofiler2::gost}.}
}
\value{
A new tibble with the original 'gene' column joined with functional
annotation columns (e.g., term_id, term_name, p_value, source).
}
\description{
Augments an annotaR object with functional enrichment data from g:Profiler.
It performs a Gene Ontology (GO) analysis on the gene list and joins the
results.
}
\examples{
\donttest{
  annotaR(c("TP53", "EGFR")) \%>\%
    add_go_terms()
}
}
