% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{simplify_unit}
\alias{simplify_unit}
\title{Simplify compound unit expressions}
\usage{
simplify_unit(x, as_character = FALSE)
}
\arguments{
\item{x}{A units object, character string, or vector of either to be simplified.}

\item{as_character}{Logical. TRUE returns the result as a character,
FALSE (default) as a unit object.}
}
\value{
A simplified units object, or a list of units objects if input is a vector.
}
\description{
This function takes a units object or a character string representing a unit expression
and returns a simplified units using the units package simplifications.
}
\examples{
# Using a units object
u <- units::set_units(1, "L*g/mg", mode = "standard")
simplify_unit(u)

# Using a character string
simplify_unit("(mg*L)/(mL)")

}
