% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_nni.R
\encoding{UTF-8}
\name{NNIDist}
\alias{NNIDist}
\alias{NNIDiameter}
\title{Approximate Nearest Neighbour Interchange distance}
\usage{
NNIDist(tree1, tree2 = tree1)

NNIDiameter(tree)
}
\arguments{
\item{tree1, tree2}{Single trees of class \code{phylo} to undergo comparison.}

\item{tree}{Object of supported class representing a tree or list of trees,
or an integer specifying the number of leaves in a tree/trees.}
}
\value{
\code{NNIDist()} returns, for each pair of trees, a named vector
containing three integers:
\itemize{
\item \code{lower} is a lower bound on the NNI distance, and corresponds
to the RF distance between the trees.
\item \code{tight_upper} is an upper bound on the distance, based on calculated
maximum diameters for trees with < 13 leaves.  \emph{NA} is returned if trees are
too different to employ this approach.
\item \code{loose_upper} is a looser upper bound on the distance, using \emph{n} log \emph{n} +
O(\emph{n}).
}

\code{NNIDiameter()} returns a matrix specifying (bounds on) the diameter
of the NNI distance metric on the specified tree(s).
Columns correspond to:
\itemize{
\item \code{liMin}:  \deqn{n - 3}{_n_ &minus; 3;}, a lower bound on the diameter
(Li \emph{et al.} 1996);
\item \code{fackMin}: Lower bound on diameter following Fack \emph{et al}. (2002), i.e.
\deqn{\log2{N!} / 4}{log&#8322; (_N_!) / 4};
\item \code{min}: The larger of \code{liMin} and \code{fackMin};
\item \code{exact}: The exact value of the diameter, where \emph{n} < 13;
\item \code{liMax}: Upper bound on diameter following Li \emph{et al.} (1996), i.e.
\deqn{n \log2{n} + \textrm{O}(n)}{n log&#8322; _n_ + O(_n_)};
\item \code{fackMax}: Upper bound on diameter following Fack \emph{et al}. (2002), i.e.
(\deqn{N - 2}{_N_ &minus; 2}) ceiling(\deqn{\log2{n}}{log&#8322; _N_})
\itemize{
\item \emph{N};
}
\item \code{max}: The smaller of \code{liMax} and \code{fackMax};
}

where \emph{n} is the number of leaves, and \emph{N} the number of internal nodes,
i.e. \deqn{n - 2}{_n_ &minus; 2}.
}
\description{
Use the approach of \insertCite{Li1996;textual}{TreeDist} to approximate the
Nearest Neighbour Interchange distance \insertCite{Robinson1971}{TreeDist}
between phylogenetic trees.
}
\details{
In brief, this approximation algorithm works by identifying edges in one
tree that do not match edges in the second.  Each of these edges must
undergo at least one NNI operation in order to reconcile the trees.
Edges that match in both trees need never undergo an NNI operation, and
divide each tree into smaller regions.  By "cutting" matched edges into two,
a tree can be divided into a number of regions that solely comprise unmatched
edges.

These regions can be viewed as separate trees that need to be reconciled.
One way to reconcile these trees is to conduct a series of NNI operations
that reduce a tree to a pectinate (caterpillar) tree, then to conduct an
analogue of the mergesort algorithm.  This takes at most \emph{n} log \emph{n} + O(\emph{n})
NNI operations, and provides a loose upper bound on the NNI score.
The maximum number of moves for an \emph{n}-leaf tree
(\href{https://oeis.org/A182136}{OEIS A182136}) can be calculated exactly for
small trees \insertCite{Fack2002}{TreeDist}; this provides a tighter upper
bound, but is unavailable for \emph{n} > 12.
\code{NNIDiameter()} reports the limits on this bound.

\tabular{rccccccccccccc}{
Leaves:   \tab 1 \tab 2 \tab 3 \tab 4 \tab 5 \tab 6 \tab 7 \tab 8 \tab 9
\tab 10 \tab 11 \tab 12 \tab 13 \cr
Diameter: \tab 0 \tab 0 \tab 0 \tab 1 \tab 3 \tab 5 \tab 7 \tab 10 \tab 12
\tab 15 \tab 18 \tab 21 \tab ? \cr
}
}
\examples{
library("TreeTools", quietly = TRUE)

NNIDist(BalancedTree(7), PectinateTree(7))

NNIDist(BalancedTree(7), as.phylo(0:2, 7))
NNIDist(as.phylo(0:2, 7), PectinateTree(7))

NNIDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))

CompareAll(as.phylo(30:33, 8), NNIDist)
}
\references{
\insertAllCited{}
}
\seealso{
Other tree distances: 
\code{\link{HierarchicalMutualInfo}()},
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
