% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_exposure_towards_wind_flux}
\alias{wbt_exposure_towards_wind_flux}
\title{Exposure towards wind flux}
\usage{
wbt_exposure_towards_wind_flux(
  dem,
  output,
  azimuth = "",
  max_dist = "",
  zfactor = "",
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file.}

\item{output}{Name of the output raster file.}

\item{azimuth}{Wind azimuth, in degrees.}

\item{max_dist}{Optional maximum search distance. Minimum value is 5 x cell size.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Evaluates hydrologic connectivity within a DEM.
}
\keyword{GeomorphometricAnalysis}
