% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{\%then\%}
\alias{\%then\%}
\title{Applying parsers in sequence}
\usage{
p1 \%then\% p2
}
\arguments{
\item{p1, p2}{two parsers.}
}
\value{
A parser.
}
\description{
\code{(p1 \%then\% p2)} recognizes anything that \code{p1} and \code{p2} would if applied in
succession.
}
\section{Pseudocode}{

\preformatted{
(p1 \%then\% p2)(x):
  if p1(x)==[] or x==null then fail()(x)
  else
    if p2(x[-1])==[] then fail()(x)
    else succeed([p1(x)$L, p2(x[-1])$L])(x[-2])
}

where \code{null} is the empty vector, \code{x[-1]} and \code{x[-2]} are the vector \code{x}
without the first element and without the first two elements, respectively.
}

\examples{
starts_with_a <- function(x) grepl("^a", x[1])
starts_with_b <- function(x) grepl("^b", x[1])
(satisfy(starts_with_a) \%then\% satisfy(starts_with_b))(c("ab", "bc", "de")) # success
(satisfy(starts_with_a) \%then\% satisfy(starts_with_b))(c("bb", "bc", "de")) # failure
(satisfy(starts_with_a) \%then\% satisfy(starts_with_b))(c("ab", "ac", "de")) # failure

}
\seealso{
The discarding versions \link{\%xthen\%} and \link{\%thenx\%}
}
