% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_travelwarning.R
\name{travelwarning_warning}
\alias{travelwarning_warning}
\title{Get a travel warning by content id}
\usage{
travelwarning_warning(content_id, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{content_id}{Travel warning content id.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with travel warning details.

Includes \code{last_modified_time} and \code{effective_time} as POSIXct in Europe/Berlin.
}
\description{
Get a travel warning by content id
}
\details{
Returns the full travel warning content, including HTML blocks.
Official docs: https://travelwarning.api.bund.dev.
}
\examples{
\dontrun{
warnings <- travelwarning_warnings()
travelwarning_warning(warnings$content_id[[1]])
}

}
\seealso{
\code{\link[=travelwarning_warnings]{travelwarning_warnings()}} to list available ids.
}
