% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_mudab.R
\name{mudab_project_stations}
\alias{mudab_project_stations}
\title{List MUDAB project stations}
\usage{
mudab_project_stations(
  filter = NULL,
  range = NULL,
  orderby = NULL,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{filter}{Optional filter definition.}

\item{range}{Optional range specification.}

\item{orderby}{Optional ordering specification.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with project stations.
}
\description{
List MUDAB project stations
}
\details{
Returns project stations from the MUDAB database.
Official docs: https://mudab.api.bund.dev.
}
\examples{
\dontrun{
mudab_project_stations(range = list(from = 0, count = 5))
}

}
