% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_handelsregister.R
\name{handelsregister_search}
\alias{handelsregister_search}
\title{Search the Handelsregister portal}
\usage{
handelsregister_search(
  schlagwoerter,
  schlagwort_optionen = c("all", "min", "exact"),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{schlagwoerter}{Search terms.}

\item{schlagwort_optionen}{Keyword options.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with search results.
}
\description{
This adapter scrapes the public Handelsregister search form because no
official OpenAPI specification is available for this service.
}
\details{
The Handelsregister search is provided via a public web form. This helper
automates the form flow and parses the result table into a tidy tibble.
Official docs: https://github.com/bundesAPI/handelsregister.

The registry notes that more than 60 requests per hour may violate the terms
of use. Use \code{safe = TRUE} to respect the built-in rate limiting.
}
\examples{
\dontrun{
handelsregister_search("Deutsche Bahn", schlagwort_optionen = "all")
}

}
\seealso{
\code{\link[=bunddev_rate_limit_get]{bunddev_rate_limit_get()}} to inspect the configured limit.
}
