% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.calculate.extension.R
\name{delta.calculate.extension}
\alias{delta.calculate.extension}
\title{Calculates the rank-based test statistic for Y and S and the difference, delta, accomodating paired data and allowing for a two-sided test}
\usage{
delta.calculate.extension(yone, yzero, sone, szero, paired = FALSE)
}
\arguments{
\item{yone}{numeric vector of primary response values in the treated group.}

\item{yzero}{numeric vector of primary response values in the untreated group.}

\item{sone}{matrix or dataframe of surrogate candidates in the treated group
with dimension \code{n1 x p} where n1 is the number of treated samples
and p the number of candidates. Sample ordering must match exactly
\code{yone}.}

\item{szero}{matrix or dataframe of surrogate candidates in the untreated group
with dimension \code{n0 x p} where n0 is the number of untreated
samples and p the number of candidates. Sample ordering must match
exactly \code{yzero}.}

\item{paired}{logical flag giving if the data is independent or paired. If
\code{FALSE} (default), samples are assumed independent. If
\code{TRUE}, samples are assumed to be from a paired design. The
pairs are specified by matching the rows of \code{yone} and
\code{sone} to the rows of \code{yzero} and \code{szero}.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{u.y}: Rank-based test statistic for the primary outcome}
\item{\code{u.s}: Rank-based test statistic for the surrogate}
\item{\code{delta.estimate}: Estimated difference between outcome and surrogate statistics}
\item{\code{sd.u.y}: Standard deviation of the outcome statistic}
\item{\code{sd.u.s}: Standard deviation of the surrogate statistic}
\item{\code{sd.delta}: Standard error of the delta estimate}
}
}
\description{
This function calculates the difference in treatment effects on a univariate marker
and on a continuous primary response. This extends the \code{delta.calculate()} function to the case where samples may be paired instead of
independent, and where a two sided test is desired.
}
\details{
This function estimates the difference (\code{delta}) between two rank-based statistics
(e.g., Wilcoxon statistics or paired ranks) for a primary outcome and a surrogate,
under either an independent or paired design.
}
\examples{
# Load data
data("example.data")
yone <- example.data$y1
yzero <- example.data$y0
sone <- example.data$s1
szero <- example.data$s0
delta.calculate.extension.result <- delta.calculate.extension(
  yone, yzero, sone, szero,
  paired = TRUE
)
}
\author{
Arthur Hughes, Layla Parast
}
