% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{sm_select_optimal_k}
\alias{sm_select_optimal_k}
\title{Select Optimal Number of Topics}
\usage{
sm_select_optimal_k(
  dtm,
  k_range = seq(2, 20, by = 2),
  method = "gibbs",
  seed = 1729,
  iter = 500,
  burnin = 100,
  plot = TRUE
)
}
\arguments{
\item{dtm}{A DocumentTermMatrix object.}

\item{k_range}{Vector of k values to test. Default is seq(2, 20, by = 2).}

\item{method}{Topic modeling method. Options: "gibbs" or "vem".
Default is "gibbs".}

\item{seed}{Random seed for reproducibility. Default is 1729.}

\item{iter}{Number of Gibbs iterations (if method = "gibbs").
Default is 500.}

\item{burnin}{Number of burn-in iterations (if method = "gibbs").
Default is 100.}

\item{plot}{Logical indicating whether to display the coherence plot.
Default is TRUE.}
}
\value{
A list containing:
  \item{optimal_k}{The k value with the highest coherence score}
  \item{results}{Data frame with k and coherence for each tested value}
  \item{plot}{A ggplot object showing coherence vs k}
}
\description{
Tests multiple values of k (number of topics) and calculates topic
coherence for each. Returns the optimal k based on maximum coherence
score, along with a comparison plot.
}
\examples{
\dontrun{
# Requires document-term matrix from sm_create_dtm()
dtm <- sm_create_dtm(processed_data)
k_selection <- sm_select_optimal_k(dtm, k_range = c(5, 10, 15, 20))
print(k_selection$optimal_k)
}
}
