% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{CorrStudy}
\alias{CorrStudy}
\title{Investigate the effect of correlated input parameters}
\usage{
CorrStudy(params, m = 1e+05, rho = seq(0.1, 0.9, by = 0.2), QMC = FALSE,
  seed = 1)
}
\arguments{
\item{params}{named list containing numeric vectors Phi, Rho, Chi, 
Ksi, M, G and A with the ranges for the input parameters.}

\item{m}{numeric scalar containing the number of Monte Carlo
replications (for each correlation intensity). Defaults to \code{1e5}.}

\item{rho}{a numeric vector containing correlation intensities. Defaults to
\code{seq(0.1,0.9,by=0.2)}.}

\item{QMC}{logical scalar. If \code{TRUE}, an equidistant grid is
generated, if \code{FALSE}, uniformly distributed random numbers are
simulated.}

\item{seed}{numeric scalar containing the random seed for each
simulation. Defaults to \code{1} in order to make results reproducible.}
}
\value{
A matrix containing the results of the repeated simulations.
}
\description{
\code{CorrStudy} investigates the effect of correlated input parameters
}
\details{
\code{CorrStudy} performs repeated simulations via \code{LEgame} with
different values for the correlation intensity in order to illustrate
the effect of correlation on the deterrent effect of the legal exemption
system.
}
\examples{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
res <- CorrStudy(params=Par, m=10000)
print(res)
}
