% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_stats.R
\name{moranI}
\alias{moranI}
\title{Calculate Moran's I Statistic}
\usage{
moranI(x, W, standardize = TRUE)
}
\arguments{
\item{x}{Numeric vector of values (e.g., gene expression).}

\item{W}{Square numeric matrix of spatial weights.
Must have the same dimension as length(x).}

\item{standardize}{Logical. If TRUE (default), row-standardize the weights matrix.}
}
\value{
A list containing:
  \itemize{
    \item \code{observed}: The observed Moran's I statistic
    \item \code{expected}: Expected value under null hypothesis of no spatial
      autocorrelation (typically -1/(n-1))
    \item \code{sd}: Standard deviation under null hypothesis
  }
}
\description{
Computes Moran's I spatial autocorrelation statistic for a numeric vector
given a spatial weights matrix.
}
\details{
Moran's I is defined as:
\deqn{I = \frac{n}{W} \frac{\sum_i \sum_j w_{ij}(x_i - \bar{x})(x_j - \bar{x})}{\sum_i (x_i - \bar{x})^2}}

where n is the number of observations, W is the sum of all weights, and
w_ij is the weight between locations i and j.

Under the null hypothesis of no spatial autocorrelation:
\itemize{
  \item Expected value: E[I] = -1/(n-1)
  \item Variance is computed using the analytical formula from Cliff and Ord (1981)
}
}
\examples{
# Create example data
set.seed(42)
x <- rnorm(100)
coords <- cbind(runif(100), runif(100))

\donttest{
# Calculate Moran's I (requires RANN package)
if (requireNamespace("RANN", quietly = TRUE)) {
    W <- buildSpatialNetwork(coords, method = "knn", k = 6)
    result <- moranI(x, W)
    print(result)
}
}

}
\references{
Cliff, A.D. and Ord, J.K. (1981) Spatial Processes: Models & Applications. Pion.
}
