#' Compute Dynamic Joe Copula Parameter
#'
#' Computes the Joe copula parameter dynamically based on lagged values and covariates.
#'
#' @param params Numeric vector of parameters: omega, alpha, and gamma coefficients.
#' @param lagged_theta Numeric, the previous theta value.
#' @param X_t Numeric vector or matrix of covariates at time t.
#' @return Numeric, estimated dynamic Joe copula parameter.
#' @export
dynamic.theta.joe <- function(params, lagged_theta, X_t) {
  omega <- params[1]
  alpha <- params[2]
  gamma <- params[3:length(params)]
  theta_t <- abs(omega + alpha * lagged_theta + sum(gamma * X_t)) + 1
  return(theta_t)
}
