% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SRscore_top.R
\name{plot_SRscore_top}
\alias{plot_SRscore_top}
\title{Barplot of Top Genes Ranked by Absolute SRscore}
\usage{
plot_SRscore_top(srscore, top_n = 20)
}
\arguments{
\item{srscore}{A data.frame containing at least a column named \code{score},
representing the SRscore values for genes.}

\item{top_n}{Integer (default: 20).
The number of top genes to plot, ranked by \code{|SRscore|}.}
}
\value{
Invisibly returns the data.frame of selected top genes (after sorting).
A barplot is produced as a side effect.
}
\description{
This function selects the top \code{top_n} genes with the largest absolute
SRscore values and visualizes their SRscores using a barplot.
The function is useful for quickly identifying genes with the strongest
positive or negative stress responses.
}
\details{
The function performs the following steps:
\itemize{
\item Validates the input data structure.
\item Computes absolute SRscore via \code{abs(score)}.
\item Selects the top \code{top_n} genes with the largest absolute score.
\item Re-sorts the selected genes by actual SRscore (to separate up/down).
\item Produces a barplot in which gene names (character columns) are used as labels.
}

The barplot displays:
\itemize{
\item Positive SRscore (upregulated genes) as upward bars.
\item Negative SRscore (downregulated genes) as downward bars.
\item Genes ordered from lowest to highest SRscore for visual clarity.
}

Graphical parameters are temporarily modified, and restored automatically
using \code{on.exit()} to avoid affecting the user's plotting environment.
}
\examples{
# Example data.frame of SRscore
df <- data.frame(
  gene = paste0("Gene", 1:10),
  score = c(-12, -6, -3, 1, 2, 3, 5, 8, 10, 11)
)

# Plot top 5 genes by |SRscore|
plot_SRscore_top(df, top_n = 5)

}
