% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MERS.R
\name{MERS}
\alias{MERS}
\title{P values for shapes obtained from semi-parametric shape-restricted mixed effects regression splines.}
\usage{
MERS(
  y,
  xMain,
  xConf = NULL,
  xRand,
  dataset,
  knotType = 2,
  preKnot = NULL,
  nBasis = 5,
  nIter
)
}
\arguments{
\item{y}{The name of the outcome.}

\item{xMain}{The name of the main effect.}

\item{xConf}{The name vector of the confounders.}

\item{xRand}{The name of the random effect.}

\item{dataset}{A data frame.}

\item{knotType}{The knot type: 1=equal-spaced, 2=quantile, 3=pre-specified.}

\item{preKnot}{The pre-specified knots.}

\item{nBasis}{The number of bases.}

\item{nIter}{The number of iterations.}
}
\value{
A list of weights of beta distribution and p-values.
}
\description{
P values for shapes obtained from semi-parametric shape-restricted mixed effects regression splines.
}
\examples{
shape <- MERS(y = "ySim", xMain = "hormone",
              xConf = c("age", "invwt", "race2", "race3", "race4", "race5",
                        "season2", "season3", "season4", "smoking1", "ovum1", "diabetes1"),
              xRand = "cluster",
              dataset = data.sim.mixed, nBasis = 5, nIter = 50)
shape
}
