% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PetBirds.R
\docType{data}
\name{PetBirds}
\alias{PetBirds}
\title{Pet birds}
\format{
A data frame with 4 rows (each combination) and 3 columns:
\describe{
  \item{LC}{Whether the adult had lung cancer; one of \code{Adults with lung cancer} or \code{Adults without lung cancer}}
  \item{Pets}{Whether the adult kept pet birds; one of \code{Kept pet birds} or \code{Did not keep pet birds}}
  \item{Counts}{The number of adults with the given combination}
}
}
\source{
Kohlmeier, L., G. Arminger, S. Bartolomeycik, B. Bellach, J. Rehm, 
and M. Thamm. 1992.
Pet birds as an independent risk factor for lung cancer: case-control study. 
\emph{British Medical Journal} \bold{305} (6860): 986--89.
}
\usage{
data(PetBirds)
}
\description{
Lung cancer and owning pet birds.
}
\examples{
barplot( xtabs(Counts ~ LC + Pets, data = PetBirds), ylab = "Number of adults")

}
\keyword{datasets}
