% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_sampler}
\alias{gibbs_sampler}
\title{Gibbs sampler for probit models}
\usage{
gibbs_sampler(
  sufficient_statistics,
  prior,
  latent_classes,
  fixed_parameter,
  R,
  B,
  print_progress,
  ordered,
  ranked,
  save_beta_draws = FALSE
)
}
\arguments{
\item{sufficient_statistics}{[\code{list}]\cr
The output of \code{\link{sufficient_statistics}}.}

\item{prior}{[\code{list}]\cr
A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{[\code{list()} | \code{NULL}]\cr
Optionally parameters specifying the number of latent classes and their
updating scheme. The values in brackets are the default.
\itemize{
\item \code{C} (\code{1}): The fixed number (greater or equal 1) of (initial) classes.
\item \code{wb_update} (\code{FALSE}): Set to \code{TRUE} for weight-based class updates.
\item \code{dp_update} (\code{FALSE}): Set to \code{TRUE} for Dirichlet process class updates.
\item \code{Cmax} (\code{10}): The maximum number of latent classes.
}

The following specifications are used for the weight-based updating scheme:
\itemize{
\item \code{buffer} (\code{50}): The number of iterations to wait before the next update.
\item \code{epsmin} (\code{0.01}): The threshold weight for removing a latent class.
\item \code{epsmax} (\code{0.7}): The threshold weight for splitting a latent class.
\item \code{deltamin} (\code{0.1}): The minimum mean distance before merging two classes.
\item \code{deltashift} (\code{0.5}): The scale for shifting the class means after a split.
}}

\item{fixed_parameter}{[\code{list}]\cr
A named list with fixed parameter values for \code{alpha},
\code{C}, \code{s}, \code{b}, \code{Omega}, \code{Sigma}, \code{Sigma_full},
\code{beta}, \code{z}, or \code{d} for the simulation.

See \href{https://loelschlaeger.de/RprobitB/articles/v01_model_definition.html}{the vignette on model definition}
for definitions of these variables.}

\item{R}{[\code{integer(1)}]\cr
The number of iterations of the Gibbs sampler.}

\item{B}{[\code{integer(1)}]\cr
The length of the burn-in period.}

\item{print_progress}{[\code{logical(1)}]\cr
Print the Gibbs sampler progress?}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{ranked}{[\code{logical(1)}]\cr
Are the alternatives ranked?}

\item{save_beta_draws}{[\code{logical(1)}]\cr
Save draws for decider-specific coefficient vectors? Usually not recommended,
as it requires a lot of storage space.}
}
\value{
A list of Gibbs samples for
\itemize{
\item \code{Sigma},
\item \code{alpha} (only if \code{P_f > 0}),
\item \code{s}, \code{z}, \code{b}, \code{Omega} (only if \code{P_r > 0}),
\item \code{d} (only if \code{ordered = TRUE}),
}
and a vector \code{class_sequence} of length \code{R}, where the \code{r}-th
entry is the number of classes after iteration \code{r}.
}
\description{
Gibbs sampler for probit models
}
\details{
This function is not supposed to be called directly, but rather via
\code{\link{fit_model}}.
}
\keyword{gibbs_sampler}
