% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_cov_names.R
\name{as_cov_names}
\alias{as_cov_names}
\title{Re-label alternative specific covariates}
\usage{
as_cov_names(choice_data, cov, alternatives)
}
\arguments{
\item{choice_data}{[\code{data.frame}]\cr
Choice data in wide format, where each row represents one choice occasion.}

\item{cov}{[\code{character()}]\cr
Names of alternative specific covariates in \code{choice_data}.}

\item{alternatives}{[\code{atomic()}]\cr
The alternative names.}
}
\value{
The \code{choice_data} input with updated column names.
}
\description{
In \code{{RprobitB}}, alternative specific covariates must be named in the
format \code{"<covariate>_<alternative>"}. This helper function generates the
format for a given \code{choice_data} set.
}
\examples{
data("Electricity", package = "mlogit")
cov <- c("pf", "cl", "loc", "wk", "tod", "seas")
alternatives <- 1:4
colnames(Electricity)
Electricity <- as_cov_names(Electricity, cov, alternatives)
colnames(Electricity)

}
