% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_U}
\alias{update_U}
\title{Update utility vector}
\usage{
update_U(U, y, sys, Sigma_inv)
}
\arguments{
\item{U}{[\code{numeric(J - 1)}]\cr
The current utility vector.}

\item{y}{[\code{integer(1)}]\cr
The index of the chosen alternative, from \code{1} to \code{J}.}

\item{sys}{[\code{numeric(J - 1)}]\cr
The systematic utility.}

\item{Sigma_inv}{[\code{matrix(J - 1, J - 1)}]\cr
The inverted error covariance matrix.}
}
\value{
An update for (a single) \code{U}.
}
\description{
Update utility vector
}
\examples{
U <- sys <- c(0, 0, 0)
Sigma_inv <- diag(3)
lapply(1:4, function(y) update_U(U, y, sys, Sigma_inv))

}
\keyword{gibbs_sampler}
