% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_cov_adj.R
\name{get_beta_estimates}
\alias{get_beta_estimates}
\alias{h_get_beta_estimates}
\alias{h_get_strat_beta_estimates}
\title{Calculate Coefficient Estimates from Linear Model Input}
\usage{
h_get_beta_estimates(lm_input)

h_get_strat_beta_estimates(strat_lm_input)
}
\arguments{
\item{lm_input}{(\code{list}) A list containing the linear model input data for each treatment arm, as returned by
\code{\link[=h_get_lm_input]{h_get_lm_input()}}.}

\item{strat_lm_input}{(\code{list}) A list of lists, one for each stratum, containing the linear model input data
for each treatment arm, as returned by \code{\link[=h_get_strat_lm_input]{h_get_strat_lm_input()}}.}
}
\value{
A list containing the coefficient estimates for each treatment arm.
}
\description{
Calculate the coefficient estimates for each treatment arm from the linear model input data.
}
\section{Functions}{
\itemize{
\item \code{h_get_beta_estimates()}: Calculate the coefficient estimates for the overall data set.

\item \code{h_get_strat_beta_estimates()}: Calculate the coefficient estimates using the stratified input.

}}
\keyword{internal}
