% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-effect.R
\name{true_effects}
\alias{true_effects}
\title{Compute estimated true effect sizes}
\usage{
true_effects(
  object,
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  as_samples = FALSE
)
}
\arguments{
\item{object}{a fitted RoBMA object}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "ensemble"}.}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{as_samples}{whether posterior samples instead of a summary table should
be returned. Defaults to \code{FALSE}.}
}
\value{
\code{pooled_effect} returns a list of tables of class 'BayesTools_table'.
}
\description{
\code{true_effects} computes the estimated true effect size
for a fitted RoBMA object. These estimates correspond to the frequentist
"Best Linear Unbiased Predictions (BLUPs)" (\link[metafor]{blup}).
Only available for normal-normal models estimated using the
spike-and-slab algorithm (i.e., \code{algorithm = "ss"}).
}
\details{
The true effect size estimates are computed under the normal likelihood. As such,
they might not approximate the true effect size estimates under selection
models well.

The conditional estimate is calculated conditional on the presence of the effect
(in meta-analysis) or the intercept (in meta-regression).
}
