% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_frequentist.R
\name{pelt}
\alias{pelt}
\title{Detect changepoints using PELT algorithm}
\usage{
pelt(
  data,
  type = "both",
  penalty = "MBIC",
  min_segment = 2,
  robust = FALSE,
  correct_ar = FALSE,
  merge_close = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix. For matrices, rows are observations.}

\item{type}{Type of change to detect: \code{"mean"}, \code{"var"}, or \code{"both"}.}

\item{penalty}{Penalty type (\code{"MBIC"}, \code{"BIC"}, \code{"AIC"}) or numeric value.}

\item{min_segment}{Minimum segment length (default: 2).}

\item{robust}{Logical or character. FALSE for standard, TRUE for moderate robustness,
or one of "mild", "moderate", "aggressive", "auto" for specific levels.}

\item{correct_ar}{Logical. Apply pre-whitening for autocorrelated data. Default: FALSE.}

\item{merge_close}{Integer or NULL. Merge changepoints within this distance. Default: NULL.}

\item{...}{Additional arguments (currently unused).}
}
\value{
List with changepoints and diagnostics
}
\description{
Wrapper for \code{\link{detect_pelt}} for compatibility.
}
\seealso{
\code{\link{detect_pelt}}
}
