% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{write_groups}
\alias{write_groups}
\title{Global filter for peak finder}
\usage{
write_groups(X, Y, minSlope, minYerror, globalFilter = TRUE)
}
\arguments{
\item{X}{x-axis data as array}

\item{Y}{y-axis data as array}

\item{minSlope}{minimum slope between bottom left corner
of rectangle and top right corner}

\item{minYerror}{minimum y difference between bottom
left corner and top right corner}

\item{globalFilter}{whether the peak finder is actually
using this filter. If not, it just returns an
array of 0s.}
}
\value{
an integer array containing 1s where the group
should be split and 0s otherwise
}
\description{
\code{write_groups} implements the global filter for the peak finder.
}
\details{
This filter tests a rectangle bounded by the peaks and troughs
in a group, and starting a new group if the rectangle
gets too large. The parameters minSlope and minYerror
determine how large a rectangle can get.
}
