% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{products_drug_tbl_df}
\alias{products_drug_tbl_df}
\title{Drug Product Records}
\format{
A tibble with 3,764 observations and 19 variables:
\describe{
  \item{name}{Character variable with the commercial name of the drug product}
  \item{labeller}{Character variable indicating the name of the pharmaceutical company}
  \item{ndc-id}{Character variable with the U.S. National Drug Code (NDC) identifier}
  \item{ndc-product-code}{Character variable for the product-level NDC code}
  \item{dpd-id}{Character variable for the Canadian Drug Product Database (DPD) ID}
  \item{ema-product-code}{Character variable for the European Medicines Agency product code}
  \item{ema-ma-number}{Character variable with the EMA marketing authorization number}
  \item{started-marketing-on}{Character variable indicating marketing start date}
  \item{ended-marketing-on}{Character variable indicating marketing end date}
  \item{dosage-form}{Character variable representing the drug's dosage form}
  \item{strength}{Character variable with the dosage strength}
  \item{route}{Character variable describing the route of administration}
  \item{fda-application-number}{Character variable for the FDA application number}
  \item{generic}{Character variable indicating if the product is a generic formulation}
  \item{over-the-counter}{Character variable indicating OTC availability}
  \item{approved}{Character variable specifying whether the product is approved}
  \item{country}{Character variable indicating the country of approval (Canada/US)}
  \item{source}{Character variable with the originating regulatory body}
  \item{parent_key}{Character variable linking to related records}
}
}
\source{
Data taken from the covid19dbcand package version 0.1.1
}
\usage{
data(products_drug_tbl_df)
}
\description{
This dataset, products_drug_tbl_df, is a tibble containing detailed information on 3,764
commercially available pharmaceutical products in Canada and the United States. Each
record includes identifiers such as NDC and DPD codes, marketing start and end dates,
strength, dosage form, administration route, approval status, and source agency.
}
\details{
The dataset name has been kept as 'products_drug_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble data frame. The original content has not been modified
in any way.
}
