% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maivefunction.r
\name{maive}
\alias{maive}
\title{R code for MAIVE}
\usage{
maive(
  dat,
  method,
  weight,
  instrument,
  studylevel,
  SE,
  AR,
  first_stage = 0L,
  estimate = NULL,
  se = NULL,
  n = NULL,
  study_id = NULL,
  seed = 123
)
}
\arguments{
\item{dat}{Data frame with columns bs, sebs, Ns, study_id (optional).}

\item{method}{1 FAT-PET, 2 PEESE, 3 PET-PEESE, 4 EK.}

\item{weight}{0 no weights, 1 standard weights, 2 MAIVE adjusted weights, 3 study weights.}

\item{instrument}{1 yes, 0 no.}

\item{studylevel}{Correlation at study level: 0 none, 1 fixed effects, 2 cluster.}

\item{SE}{SE estimator: 0 CR0 (Huber-White), 1 CR1 (Standard empirical correction),
2 CR2 (Bias-reduced estimator), 3 wild bootstrap.}

\item{AR}{Anderson Rubin corrected CI for weak instruments (available for unweighted and MAIVE-adjusted weight versions of
PET, PEESE, PET-PEESE, not available for fixed effects): 0 no, 1 yes.}

\item{first_stage}{First-stage specification for the variance model: 0 levels, 1 log.}

\item{estimate}{Optional column name to use instead of 'bs'}

\item{se}{Optional column name to use instead of 'sebs'}

\item{n}{Optional column name to use instead of 'Ns'}

\item{study_id}{Optional column name for study identifiers}

\item{seed}{Seed for the wild bootstrap when SE = 3. Use NULL to avoid setting a seed
(results depend on the current RNG state). Default is 123 for historical reproducibility.}
}
\value{
\itemize{
  \item beta: MAIVE meta-estimate
  \item SE: MAIVE standard error
  \item F-test: heteroskedastic robust F-test of the first step instrumented SEs
  \item beta_standard: point estimate from the method chosen
  \item SE_standard: standard error from the method chosen
  \item Hausman: Hausman type test: comparison between MAIVE and standard version
  \item Chi2: 5% critical value for Hausman test
  \item SE_instrumented: instrumented standard errors
  \item AR_CI: Anderson-Rubin confidence interval for weak instruments
  \item pub bias p-value: p-value of test for publication bias / p-hacking based on instrumented FAT
  \item egger_coef: Egger Coefficient (PET estimate)
  \item egger_se: Egger Standard Error (PET standard error)
  \item egger_boot_ci: Confidence interval for the Egger coefficient using the selected resampling scheme
  \item egger_ar_ci: Anderson-Rubin confidence interval for the Egger coefficient (when available)
  \item is_quadratic_fit: Details on quadratic selection and slope behaviour
  \item boot_result: Boot result
  \item slope_coef: Slope coefficient
  \item petpeese_selected: Which model (PET or PEESE) was selected when method=3 (NA otherwise)
  \item peese_se2_coef: Coefficient on SE^2 when PEESE is the final model (NA otherwise)
  \item peese_se2_se: Standard error of the PEESE SE^2 coefficient (NA otherwise)
}
}
\description{
R package for MAIVE: "Spurious Precision in Meta-Analysis of Observational Research" by
Zuzana Irsova, Pedro Bom, Tomas Havranek, Petr Cala, and Heiko Rachinger.
}
\details{
Guided, interactive workflow available at https://www.easymeta.org.

Data \code{dat} can be imported from an Excel file via:
\code{dat <- read_excel("inputdata.xlsx")} or from a csv file via: \code{dat <- read.csv("inputdata.csv")}
It should contain:
\itemize{
  \item Estimates: bs
  \item Standard errors: sebs
  \item Number of observations: Ns
  \item Optional: study_id
}
Default option for MAIVE: MAIVE-PET-PEESE, unweighted, instrumented, cluster SE, wild bootstrap, AR.
}
\examples{
dat <- data.frame(
  bs = c(0.5, 0.45, 0.55, 0.6),
  sebs = c(0.25, 0.2, 0.22, 0.27),
  Ns = c(50, 80, 65, 90)
)

result <- maive(dat,
  method = 3, weight = 0, instrument = 1,
  studylevel = 0, SE = 0, AR = 0, first_stage = 0
)

}
