% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{hiroshima_tbl_df}
\alias{hiroshima_tbl_df}
\title{Hiroshima Atomic Bomb Survivors Cancer Data}
\format{
A tibble with 6 observations and 4 variables:
\describe{
  \item{radiation}{Radiation exposure category (character)}
  \item{leukemia}{Number of deaths from leukemia (numeric)}
  \item{other cancer}{Number of deaths from other cancers (numeric)}
  \item{total cancers}{Total number of cancer deaths (numeric)}
}
}
\source{
Data taken from the dobson package version 0.4
}
\usage{
data(hiroshima_tbl_df)
}
\description{
This dataset, hiroshima_tbl_df, is a tibble containing data on the number of deaths
from leukemia and other cancers among survivors of the Hiroshima atom bomb.
The data cover deaths that occurred during the period 1950–1959 among survivors
who were aged 25 to 64 years in 1950.
}
\details{
The dataset name has been kept as 'hiroshima_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
