% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nip.rig.R
\name{nip.rig}
\alias{nip.rig}
\title{Proportion of Non-Intersecting Interval Pairs in an RIG}
\usage{
nip.rig(s, t, e1, e2)
}
\arguments{
\item{s}{Start points of intervals.}

\item{t}{End points of intervals.}

\item{e1}{Vector of indices for the first interval in each pair.}

\item{e2}{Vector of indices for the second interval in each pair.}
}
\value{
Mean proportion of non-intersecting pairs.
}
\description{
Computes the proportion of non-intersecting pairs of interval in the RIG obtained using data.
}
\examples{
s <- runif(10,0,1) 
t <- runif(10,0,1)
e1 <- c(2,10,6,1,5)
e2 <- c(4,3,8,7,9)
nip.rig(s,t,e1,e2)
}
