#' Threshold for RCAG-DD Test of randomness for circular data
#'
#' Calculates a threshold for RCAG-DD test using simulated data.
#'
#' @param m Number of observations.
#' @param n_iter Number of simulations.
#' @param alpha Level of significance.
#' @return Threshold value for RCAG-DD test.
#' thrsd.rcagdd(500,1000,0.05)
#' @export
thrsd.rcagdd <- function (m, n_iter, alpha) {
  nv = m %/% 2
  pdf_H <- numeric(n_iter)
  cdf_t <- cdf.rcag(m)
  pdf_t <- numeric(nv)
  pdf_t[1] = cdf_t[1]
  for (i in 2:nv) {
    pdf_t[i] <- cdf_t[i] - cdf_t[i - 1]
  }
  for (i in 1:n_iter) {
    x <- rcircularuniform(2 * nv)
    deg <- deg.rcag(x)
    pdf <- sapply(1:nv, function(j) sum(deg == j) / nv)
    pdf_H[i] <- hellinger.dist(pdf, pdf_t)
  }
  cutoff <- quantile(pdf_H, 1-alpha)
  return(cutoff)
}
