% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Net_embedding.R
\name{Net_embedding}
\alias{Net_embedding}
\title{Network Embedding using biased random walk and Word2Vec.}
\usage{
Net_embedding(
  net_list,
  p = 0.25,
  q = 1,
  num = 10,
  l = 80,
  vector_size = 32,
  window = 10,
  min_count = 1,
  sg_model = 1,
  workers = 4,
  epochs = 20
)
}
\arguments{
\item{net_list}{A list containing data frames that can be coerced into pandas data frames. Each data frame contains 3 columns, source, target and weight, representing the connections between nodes in the networks.}

\item{p}{A parameter for the BiasedRandomWalk.Defines probability, 1/p, of returning to source node.}

\item{q}{A parameter for the BiasedRandomWalk.Defines probability, 1/q, for moving to a node away from the source node.}

\item{num}{A parameter for the BiasedRandomWalk. Defines the number of walks per node.}

\item{l}{A parameter for the BiasedRandomWalk. Defines the length of each walk.}

\item{vector_size}{The size of the Word2Vec vectors.}

\item{window}{The window size for the Word2Vec model.}

\item{min_count}{Minimum count for the Word2Vec model.}

\item{sg_model}{Training algorithm for Word2Vec (0 for CBOW, 1 for skip-gram).}

\item{workers}{Number of worker threads to train the Word2Vec model.}

\item{epochs}{Number of epochs to train the Word2Vec model.}
}
\value{
A list of data frames with node embeddings. Each data frame contains nxm dimensions, where n is the number of unique nodes in the network and m is the number of reduced dimensions defined in the function.
}
\description{
Network Embedding using biased random walk and Word2Vec.
}
\details{
This function performs a network embedding using the python libraries stellargraph and gensim through the BiasedRandomWalk and Word2Vec functions, respectively.
}
