% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision_i3plus3.R
\name{get_decision_i3plus3}
\alias{get_decision_i3plus3}
\title{Dosing decision for the i3+3 design}
\usage{
get_decision_i3plus3(pT = NULL,
                       EI = NULL,
                       npts = 12)
}
\arguments{
\item{pT}{a numeric value that specifies the target DLT rate (\eqn{p_T}).}

\item{EI}{a vector that specifies the equivalence interval (EI).}

\item{npts}{the number of participants within which dosing decisions are generated.}
}
\value{
\code{get_decision_i3plus3()} returns:

(1) a dataframe containing the decisions (E, S, D or DU) for each combination of y and n (\code{$tab}),

(2) a list (\code{$setup}) containing user input parameters, such as target, EI, npts, etc.
}
\description{
Generate dosing decisions (E, S, D or DU) of the i3+3 design for user-specified number of participants.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The i3+3 design uses the following decision rules.

          If \eqn{\frac{y_d}{n_d}} is lower than the escalation boundary (i.e. below
          the EI), the decision is to escalate to the next higher dose; if
          \eqn{\frac{y_d}{n_d}} is between the escalation and de-escalation boundaries
          (i.e. inside the EI), the decision is to stay at the current dose; if
          \eqn{\frac{y_d}{n_d}} is higher than the de-escalation boundary (i.e. above
          the EI), there are two options: option one, if \eqn{\frac{y_d-1}{n_d}} is
          lower than the escalation boundary (i.e., below the EI), the decision is
          to stay at the current dose; option two, else if \eqn{\frac{y_d-1}{n_d}}
          is equal to or higher than the escalation boundary, the decision is to
          de-escalate to the next lower dose.

          Also, the i3+3 design includes a dose exclusion rule. Let \eqn{p_T} represents
          the target DLT rate. If \eqn{Pr(p_d > p_T | y_d , n_d ) > 0.95}, dose \eqn{d}
          and those higher than \eqn{d} are removed from the trial since they are deemed
          excessively toxic.
}
\examples{

get_decision_i3plus3(pT = 0.25,
                EI = c(0.2,0.3),
                npts = 12)
}
\references{
Liu M., Wang, SJ. and Ji, Y. (2020). The i3+3 Design for Phase I Clinical Trials, \emph{Journal of
biopharmaceutical statistics}, 30(2):294–304.
}
