% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDruglink.R
\name{plotDruglink}
\alias{plotDruglink}
\title{plotDruglink}
\usage{
plotDruglink(drug1,drug2,i = 5,color_MF = "#43AAEF",color_drug = "#F7525B",
layout_type = "circle")
}
\arguments{
\item{drug1}{The drugbank ID of drug1.}

\item{drug2}{The drugbank ID of drug2.}

\item{i}{Specifies the number of outputs molecular functions, which is 5 by default.}

\item{color_MF}{Defines the color of MF nodes in the network.}

\item{color_drug}{Defines the color of drug nodes in the network.}

\item{layout_type}{layout_type used to set the appropriate arrangement, there is an option to choose from "circle","dh",and "sugiyama".}
}
\value{
A bipartite network of drugs and shared molecular functions.
}
\description{
The function "plotDruglink" is used to plot a bipartite network of drugs and shared molecular functions.
}
\examples{
# Set drug1
drug1<-"DB02721"
# Set drug2
drug2<-"DB01213"
# Run the function
library(igraph)
plotDruglink(drug1,drug2,i = 5)
}
