% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugSimscore.R
\name{DrugSimscore}
\alias{DrugSimscore}
\title{DrugSimscore}
\usage{
DrugSimscore(DE,nperm = 0)
}
\arguments{
\item{DE}{A matrix with one column of zscore.}

\item{nperm}{Number of random permutations (default: 0).}
}
\value{
A dataframe with four columns those are drug1, drug2, drug1 name, drug2 name, functional similarity score and FDR.
}
\description{
The function "DrugSimscore" is used in calculating the drug functional similarity score.
}
\examples{
# Obtain the example data
GEP<-Gettest("GEP")
label<-Gettest("label")
# Run the function
DEscore<-CalDEscore(GEP,label)
# Run the function
\donttest{drug_drug<-DrugSimscore(DE=DEscore,nperm = 0)}
}
