% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/executeDqChecks.R
\name{executeDqChecks}
\alias{executeDqChecks}
\title{Execute DQ checks}
\usage{
executeDqChecks(
  connectionDetails,
  cdmDatabaseSchema,
  resultsDatabaseSchema,
  vocabDatabaseSchema = cdmDatabaseSchema,
  cdmSourceName,
  numThreads = 1,
  sqlOnly = FALSE,
  sqlOnlyUnionCount = 1,
  sqlOnlyIncrementalInsert = FALSE,
  outputFolder,
  outputFile = "",
  verboseMode = FALSE,
  writeToTable = TRUE,
  writeTableName = "dqdashboard_results",
  writeToCsv = FALSE,
  csvFile = "",
  checkLevels = c("TABLE", "FIELD", "CONCEPT"),
  checkNames = c(),
  checkSeverity = c("fatal", "convention", "characterization"),
  cohortDefinitionId = c(),
  cohortDatabaseSchema = resultsDatabaseSchema,
  cohortTableName = "cohort",
  tablesToExclude = c("CONCEPT", "VOCABULARY", "CONCEPT_ANCESTOR",
    "CONCEPT_RELATIONSHIP", "CONCEPT_CLASS", "CONCEPT_SYNONYM", "RELATIONSHIP", "DOMAIN"),
  cdmVersion = "5.3",
  tableCheckThresholdLoc = "default",
  fieldCheckThresholdLoc = "default",
  conceptCheckThresholdLoc = "default"
)
}
\arguments{
\item{connectionDetails}{A connectionDetails object for connecting to the CDM database}

\item{cdmDatabaseSchema}{The fully qualified database name of the CDM schema}

\item{resultsDatabaseSchema}{The fully qualified database name of the results schema}

\item{vocabDatabaseSchema}{The fully qualified database name of the vocabulary schema (default is to set it as the cdmDatabaseSchema)}

\item{cdmSourceName}{The name of the CDM data source}

\item{numThreads}{The number of concurrent threads to use to execute the queries}

\item{sqlOnly}{Should the SQLs be executed (FALSE) or just returned (TRUE)?}

\item{sqlOnlyUnionCount}{(OPTIONAL) In sqlOnlyIncrementalInsert mode, how many SQL commands to union in each query to insert check results into results table (can speed processing when queries done in parallel). Default is 1.}

\item{sqlOnlyIncrementalInsert}{(OPTIONAL) In sqlOnly mode, boolean to determine whether to generate SQL queries that insert check results and associated metadata into results table.  Default is FALSE (for backwards compatibility to <= v2.2.0)}

\item{outputFolder}{The folder to output logs, SQL files, and JSON results file to}

\item{outputFile}{(OPTIONAL) File to write results JSON object}

\item{verboseMode}{Boolean to determine if the console will show all execution steps. Default is FALSE}

\item{writeToTable}{Boolean to indicate if the check results will be written to the dqdashboard_results table in the resultsDatabaseSchema. Default is TRUE}

\item{writeTableName}{The name of the results table. Defaults to `dqdashboard_results`.  Used when sqlOnly or writeToTable is True.}

\item{writeToCsv}{Boolean to indicate if the check results will be written to a csv file. Default is FALSE}

\item{csvFile}{(OPTIONAL) CSV file to write results}

\item{checkLevels}{Choose which DQ check levels to execute. Default is all 3 (TABLE, FIELD, CONCEPT)}

\item{checkNames}{(OPTIONAL) Choose which check names to execute. Names can be found in inst/csv/OMOP_CDM_v[cdmVersion]_Check_Descriptions.csv. Note that "cdmTable", "cdmField" and "measureValueCompleteness" are always executed.}

\item{checkSeverity}{Choose which DQ check severity levels to execute. Default is all 3 (fatal, convention, characterization)}

\item{cohortDefinitionId}{The cohort definition id for the cohort you wish to run the DQD on. The package assumes a standard OHDSI cohort table
with the fields cohort_definition_id and subject_id.}

\item{cohortDatabaseSchema}{The schema where the cohort table is located.}

\item{cohortTableName}{The name of the cohort table. Defaults to `cohort`.}

\item{tablesToExclude}{(OPTIONAL) Choose which CDM tables to exclude from the execution.}

\item{cdmVersion}{The CDM version to target for the data source. Options are "5.2", "5.3", or "5.4". By default, "5.3" is used.}

\item{tableCheckThresholdLoc}{The location of the threshold file for evaluating the table checks. If not specified the default thresholds will be applied.}

\item{fieldCheckThresholdLoc}{The location of the threshold file for evaluating the field checks. If not specified the default thresholds will be applied.}

\item{conceptCheckThresholdLoc}{The location of the threshold file for evaluating the concept checks. If not specified the default thresholds will be applied.}
}
\value{
A list object of results
}
\description{
This function will connect to the database, generate the sql scripts, and run the data quality checks against the database. By default, results will be written to a json file as well as a database table.
}
