% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableDoseForms.R
\name{associatedDoseForms}
\alias{associatedDoseForms}
\title{Get the dose forms associated with drug concepts in a codelist}
\usage{
associatedDoseForms(x, cdm)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}
}
\value{
The dose forms available for drug concepts.
}
\description{
Get the dose forms associated with drug concepts in a codelist
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all dose forms available in a codelist
codelist <- newCodelist(list("codes1" = c(194152L, 1830279L, 40558872L),
                             "codes2" = c(44022939L)))
associatedDoseForms(x = codelist, cdm = cdm)
}
}
