% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AreaWeighted.R
\name{CST_AreaWeighted}
\alias{CST_AreaWeighted}
\title{Calculate the spatial area-weighted average of multidimensional arrays.}
\usage{
CST_AreaWeighted(
  data,
  area,
  lon_dim = "lon",
  lat_dim = "lat",
  ncores = NULL,
  extra_info = NULL
)
}
\arguments{
\item{data}{An object of class \code{s2dv_cube} with at least lon_dim 
and lat_dim containing climate data.}

\item{area}{A multidimensional array with named dimensions (at least lon_dim 
and lat_dim) containing area of each grid box. The resolution, length and
 order of the lon_dim and lat_dim dimensions should be identical as for
 \code{data}. Missing values are allowed and treated as 0s.}

\item{lon_dim}{A character string indicating the name of the longitudinal
dimension. The default value is 'lon'.}

\item{lat_dim}{A character string indicating the name of the latitudinal
dimension. The default value is 'lat'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}

\item{extra_info}{A named list with additional metadata to add to the 
s2dv_cube. There can be one entry for each dimension in 'area' that is
not also present in 'data'.}
}
\value{
An object of class \code{s2dv_cube} with same dimensions as in object 
\code{data}, except with \code{lon_dim} and \code{lat_dim} removed. Any extra 
dimensions in \code{area} not present in \code{data} are preserved in the output (e.g., 
region dimension).
}
\description{
This function computes a spatial area-weighted average of n-dimensional arrays 
given a spatial mask containing the area (e.g. in m^2) for each grid box.
}
\examples{
data <- array(data = 1:10, dim = c(year = 10, lon = 5, lat = 3))
coords <- list(lat = 1:3, lon = 1:5)
data <- list(data = data, coords = coords)
attr(data, 'class') <- 's2dv_cube'
area <- array(data = 1:10, dim = c(lon = 5, lat = 3))
CST_AreaWeighted(data, area)
# With extra region dimension
area <- array(data = 1:10, dim = c(lon = 5, lat = 3, region = 4))
CST_AreaWeighted(data, area)

}
