% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_axis_doy.R
\name{ch_axis_doy}
\alias{ch_axis_doy}
\title{Generates the x axis beginning on specified day of year}
\usage{
ch_axis_doy(wyear = 1)
}
\arguments{
\item{wyear}{Month of beginning of water year, \code{wyear = 1} (the default) for 
calendar year, \code{wyear = 10} to start October 1.}
}
\value{
Plots a water year axis on a standard R plot
}
\description{
Generates an axis for day of year or day of water year; used by 
\code{ch_regime_plot}. Obtaining the day of water year needs to be done separately.
}
\examples{
a <- seq(1, 365)
b <- runif(365)
plot(a, b,  type = "p", xlab = "", xaxt = "n")
ch_axis_doy(wyear = 10) # starts in October
}
\seealso{
\code{\link{ch_regime_plot}}
}
\author{
Paul Whitfield
}
