% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{read_thermal_batch}
\alias{read_thermal_batch}
\title{Batch Read .raw Files}
\usage{
read_thermal_batch(folder_path, pattern = "\\\\.raw$", recursive = FALSE, ...)
}
\arguments{
\item{folder_path}{String. Path to the folder.}

\item{pattern}{String. Regex pattern. Default is "\\.raw$".}

\item{recursive}{Logical. Default is FALSE.}

\item{...}{Additional arguments passed to \code{read_thermal_raw}.}
}
\value{
A named list of "BioThermR" objects.
}
\description{
Scans a folder and imports all matching .raw files into a list.
}
\examples{
\donttest{
# Example using raw thermal files
img_obj_list <- system.file("extdata",package = "BioThermR")
img_list <- read_thermal_batch(img_obj_list)
}
}
