% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car.R
\name{bi.dist.car}
\alias{bi.dist.car}
\title{Conditional Autoregressive (CAR) Distribution}
\usage{
bi.dist.car(
  loc,
  correlation,
  conditional_precision,
  adj_matrix,
  is_sparse = FALSE,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{Numeric vector, matrix, or array representing the mean of the distribution.}

\item{correlation}{Numeric vector, matrix, or array representing the correlation between variables.}

\item{conditional_precision}{Numeric vector, matrix, or array representing the precision of the distribution.}

\item{adj_matrix}{Numeric vector, matrix, or array representing the adjacency matrix defining the graph.}

\item{is_sparse}{Logical indicating whether the adjacency matrix is sparse. Defaults to `FALSE`.}

\item{validate_args}{Logical indicating whether to validate arguments. Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector. When `sample=False` (model building), this is used with `.expand(shape)` to set the
distribution's batch shape. When `sample=True` (direct sampling),
this is used as `sample_shape` to draw a raw JAX array of the
given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event
dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution
object instead of creating a sample site. This is essential for
building complex distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI CAR distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the CAR distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The CAR distribution models a vector of variables where each variable is a linear
combination of its neighbors in a graph. The CAR model captures spatial dependence in areal data by modeling each observation as conditionally dependent on its neighbors.
 It specifies a joint distribution of a vector of random variables \deqn{\mathbf{y} = (y_1, y_2, \dots, y_N)} based on their conditional distributions, where each \deqn{y_i} is conditionally independent of all other variables given its neighbors.
- Application: Widely used in disease mapping, environmental modeling, and spatial econometrics to account for spatial autocorrelation.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.car(
  loc = c(1.,2.),
  correlation = 0.9,
  conditional_precision = 1.,
  adj_matrix = matrix(c(1,0,0,1), nrow = 2),
  sample = TRUE
 )
}
}
