% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPP.analysis.R
\name{DPP.analysis}
\alias{DPP.analysis}
\title{Analysis of a Study Using Bayesian Hybrid Design using Dynamic Power Prior
Framework}
\usage{
DPP.analysis(
  Yt = 39,
  nt = 60,
  Yc = 13,
  nc = 30,
  Ych = 90,
  nch = 200,
  nche = 30,
  a0c = 0.001,
  b0c = 0.001,
  a0t = 0.001,
  b0t = 0.001,
  delta_threshold = 0.1,
  method = "Empirical Bayes",
  theta = 0.5,
  eta = 1
)
}
\arguments{
\item{Yt}{A scalar. Response rate for experimental arm in current study.}

\item{nt}{A scalar. sample size for experimental arm.}

\item{Yc}{A scalar. Response rate for control arm in current study.}

\item{nc}{A scalar. sample size for control arm.}

\item{Ych}{A scalar. Number of responders in historical control.}

\item{nch}{A scalar. Total number of subjects in historical control.}

\item{nche}{A scalar. maximum amount of borrowing in terms of equivalent
number of subjects.}

\item{a0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).
Default 0.001.}

\item{b0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).
Default 0.001.}

\item{a0t}{A scalar. Hyperprior for experimental response rate beta(a0t, b0t).
Default 0.001.}

\item{b0t}{A scalar. Hyperprior for experimental response rate beta(a0t, b0t).
Default 0.001.}

\item{delta_threshold}{Borrow when abs(pc_hat (current study) - pch) <=
delta_threshold#'. Default 0.1.}

\item{method}{A string characters. Method for dynamic borrowing, "Empirical
Bayes", "Bayesian p", "Generalized BC", "JSD". Default "Empirical Bayes".}

\item{theta}{A scalar parameter with a range of (0, 1), and applicable to
method: "Generalized BC". Default 0.5.}

\item{eta}{A scalar parameter with a range of (0, infty), and applicable to
method: "Bayesian p", "Generalized BC", "JSD". "Generalized BC" method
requires two parameters theta and eta. Default 1.}
}
\value{
An object of class \code{list} with values:
\itemize{
\item w: Borrowing weight.
\item phat_pt_larger_pc: Posterior probability P(ORR_trt > ORR_ctrl | data).
\item apost_c_trial, bpost_c_trial: Parameters for the posterior Beta
distribution of the concurrent control arm response rate.
\item apost_c_hca, bpost_c_hca: Parameters for the posterior Beta
distribution of the hybrid control arm response rate.
\item apost_t, bpost_t: Parameters for the posterior Beta
distribution of the experimental arm response rate.
\item m.t: Posterior median response rate for the experimental arm.
\item m.c: Posterior median response rate for the concurrent control arm.
\item m.hca: Posterior median response rate for the hybrid control arm.
}
}
\description{
This function Perform Analysis for a Study Using Bayesian Hybrid Design using
Dynamic Power Prior Framework.
}
\examples{
\donttest{
o <- DPP.analysis(Yt=39, nt=60, Yc=13, nc=30, Ych=90, nch=200, nche = 30,
a0c= 0.001, b0c= 0.001, a0t= 0.001, b0t= 0.001,
delta_threshold = 0.1, method = "Empirical Bayes",
theta = 0.5, eta = 1)
print(o)
}

}
